%------------------------------------------------------------------------------
% File     : NUM812^5 : TPTP v7.4.0. Bugfixed v5.2.0.
% Domain   : Number Theory (Induction on naturals)
% Problem  : TPS problem THM578
% Version  : Especial.
% English  : Variant of THM6104, including induction in the hypothesis.

% Refs     : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : tps_0443 [Bro09]
%          : THM578 [TPS]

% Status   : Theorem
% Rating   : 0.29 v7.4.0, 0.11 v7.2.0, 0.12 v7.0.0, 0.00 v6.2.0, 0.14 v5.5.0, 0.17 v5.4.0, 0.40 v5.3.0, 0.60 v5.2.0
% Syntax   : Number of formulae    :    5 (   0 unit;   3 type;   1 defn)
%            Number of atoms       :   19 (   3 equality;  10 variable)
%            Maximal formula depth :    9 (   5 average)
%            Number of connectives :   11 (   0   ~;   1   |;   1   &;   6   @)
%                                         (   0 <=>;   3  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    2 (   2   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    5 (   3   :;   0   =)
%            Number of variables   :    5 (   0 sgn;   4   !;   1   ?;   0   ^)
%                                         (   5   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : This problem is from the TPS library. Copyright (c) 2009 The TPS
%            project in the Department of Mathematical Sciences at Carnegie
%            Mellon University. Distributed under the Creative Commons copyleft
%            license: http://creativecommons.org/licenses/by-sa/3.0/
%          : 
% Bugfixes : v5.2.0 - Added missing type declarations.
%------------------------------------------------------------------------------
thf(c0_type,type,(
    c0: $i )).

thf(cS_type,type,(
    cS: $i > $i )).

thf(cIND_type,type,(
    cIND: $o )).

thf(cIND_def,definition,
    ( cIND
    = ( ! [Xp: $i > $o] :
          ( ( ( Xp @ c0 )
            & ! [Xx: $i] :
                ( ( Xp @ Xx )
               => ( Xp @ ( cS @ Xx ) ) ) )
         => ! [Xx: $i] :
              ( Xp @ Xx ) ) ) )).

thf(cTHM578,conjecture,
    ( cIND
   => ! [Xn: $i] :
        ( ( Xn = c0 )
        | ? [Xm: $i] :
            ( Xn
            = ( cS @ Xm ) ) ) )).

%------------------------------------------------------------------------------
